<?php
declare(strict_types=1);

function panel_render(string $page, array $data=[]): void {
  $tenant = $GLOBALS['tenant'];
  $u = auth_user();
  view('layouts/panel', array_merge($data, [
    'tenant' => $tenant,
    'user' => $u,
    'page' => $page,
  ]));
}

function panel_dashboard(): void {
  $pdo = $GLOBALS['pdo'];
  $cid = (int)$GLOBALS['tenant']['id'];

  $st = $pdo->prepare("SELECT COUNT(*) c FROM customers WHERE company_id=? AND deleted_at IS NULL");
  $st->execute([$cid]);
  $customersCount = (int)($st->fetch()['c'] ?? 0);

  $st = $pdo->prepare("SELECT COUNT(*) c FROM products WHERE company_id=? AND deleted_at IS NULL");
  $st->execute([$cid]);
  $productsCount = (int)($st->fetch()['c'] ?? 0);

  // v0.3: documents gelince burası gerçek open invoice/quote olacak
  $openInvoices = 0;
  $openQuotes = 0;

  panel_render('dashboard', compact('customersCount','productsCount','openInvoices','openQuotes'));
}

function panel_invoices(): void { panel_render('invoices'); }
function panel_quotes(): void { panel_render('quotes'); }

function panel_customers(): void {
  $pdo = $GLOBALS['pdo'];
  $cid = (int)$GLOBALS['tenant']['id'];

  $st = $pdo->prepare("
    SELECT * FROM customers
    WHERE company_id=? AND deleted_at IS NULL
    ORDER BY id DESC
  ");
  $st->execute([$cid]);
  $rows = $st->fetchAll();

  $ok = flash_get('ok');
  $err = flash_get('err');
  panel_render('customers', compact('rows','ok','err'));
}

function panel_customers_post(): void {
  $pdo = $GLOBALS['pdo'];
  $cid = (int)$GLOBALS['tenant']['id'];
  $slug = (string)$GLOBALS['tenant']['slug'];

  $csrf = (string)($_POST['csrf'] ?? '');
  if (!csrf_verify($csrf)) {
    flash_set('err', 'CSRF doğrulaması başarısız.');
    redirect(base_path("/{$slug}/customers"));
  }

  $action = (string)($_POST['action'] ?? 'create');

  if ($action === 'create') {
    $name = trim((string)($_POST['name'] ?? ''));
    $email = trim((string)($_POST['email'] ?? ''));
    $phone = trim((string)($_POST['phone'] ?? ''));
    $address = trim((string)($_POST['address'] ?? ''));
    $tax_office = trim((string)($_POST['tax_office'] ?? ''));
    $tax_no = trim((string)($_POST['tax_no'] ?? ''));

    if ($name === '') {
      flash_set('err', 'Müşteri adı zorunlu.');
      redirect(base_path("/{$slug}/customers"));
    }

    $st = $pdo->prepare("
      INSERT INTO customers (company_id,name,email,phone,address,tax_office,tax_no,is_active)
      VALUES (?,?,?,?,?,?,?,1)
    ");
    $st->execute([$cid,$name,$email ?: null,$phone ?: null,$address ?: null,$tax_office ?: null,$tax_no ?: null]);

    flash_set('ok', 'Müşteri eklendi.');
    redirect(base_path("/{$slug}/customers"));
  }

  if ($action === 'trash') {
    $id = (int)($_POST['id'] ?? 0);
    if ($id > 0) {
      $st = $pdo->prepare("UPDATE customers SET deleted_at=NOW() WHERE id=? AND company_id=?");
      $st->execute([$id,$cid]);
      flash_set('ok', 'Müşteri çöp kutusuna taşındı.');
    }
    redirect(base_path("/{$slug}/customers"));
  }

  flash_set('err', 'Bilinmeyen işlem.');
  redirect(base_path("/{$slug}/customers"));
}

function panel_products(): void {
  $pdo = $GLOBALS['pdo'];
  $cid = (int)$GLOBALS['tenant']['id'];

  $st = $pdo->prepare("
    SELECT * FROM products
    WHERE company_id=? AND deleted_at IS NULL
    ORDER BY id DESC
  ");
  $st->execute([$cid]);
  $rows = $st->fetchAll();

  $ok = flash_get('ok');
  $err = flash_get('err');
  panel_render('products', compact('rows','ok','err'));
}

function panel_products_post(): void {
  $pdo = $GLOBALS['pdo'];
  $cid = (int)$GLOBALS['tenant']['id'];
  $slug = (string)$GLOBALS['tenant']['slug'];

  $csrf = (string)($_POST['csrf'] ?? '');
  if (!csrf_verify($csrf)) {
    flash_set('err', 'CSRF doğrulaması başarısız.');
    redirect(base_path("/{$slug}/products"));
  }

  $action = (string)($_POST['action'] ?? 'create');

  if ($action === 'create') {
    $name = trim((string)($_POST['name'] ?? ''));
    $unit = trim((string)($_POST['unit'] ?? 'adet')) ?: 'adet';
    $price = (float)($_POST['price'] ?? 0);
    $vat = (float)($_POST['vat_rate'] ?? 20);
    $desc = trim((string)($_POST['description'] ?? ''));

    if ($name === '') {
      flash_set('err', 'Ürün/Hizmet adı zorunlu.');
      redirect(base_path("/{$slug}/products"));
    }

    $st = $pdo->prepare("
      INSERT INTO products (company_id,name,description,unit,price,vat_rate,is_active)
      VALUES (?,?,?,?,?,?,1)
    ");
    $st->execute([$cid,$name,$desc ?: null,$unit,$price,$vat]);

    flash_set('ok', 'Ürün/Hizmet eklendi.');
    redirect(base_path("/{$slug}/products"));
  }

  if ($action === 'trash') {
    $id = (int)($_POST['id'] ?? 0);
    if ($id > 0) {
      $st = $pdo->prepare("UPDATE products SET deleted_at=NOW() WHERE id=? AND company_id=?");
      $st->execute([$id,$cid]);
      flash_set('ok', 'Ürün/Hizmet çöp kutusuna taşındı.');
    }
    redirect(base_path("/{$slug}/products"));
  }

  flash_set('err', 'Bilinmeyen işlem.');
  redirect(base_path("/{$slug}/products"));
}

function panel_settings(): void { panel_render('settings'); }
function panel_company(): void { panel_render('company'); }

function panel_trash(): void {
  $pdo = $GLOBALS['pdo'];
  $cid = (int)$GLOBALS['tenant']['id'];

  $st = $pdo->prepare("SELECT id,name,email,deleted_at,'customer' AS kind FROM customers WHERE company_id=? AND deleted_at IS NOT NULL");
  $st->execute([$cid]);
  $customers = $st->fetchAll();

  $st = $pdo->prepare("SELECT id,name,NULL AS email,deleted_at,'product' AS kind FROM products WHERE company_id=? AND deleted_at IS NOT NULL");
  $st->execute([$cid]);
  $products = $st->fetchAll();

  $ok = flash_get('ok');
  $err = flash_get('err');
  panel_render('trash', compact('customers','products','ok','err'));
}

function panel_trash_restore_post(): void {
  $pdo = $GLOBALS['pdo'];
  $cid = (int)$GLOBALS['tenant']['id'];
  $slug = (string)$GLOBALS['tenant']['slug'];

  $csrf = (string)($_POST['csrf'] ?? '');
  if (!csrf_verify($csrf)) {
    flash_set('err', 'CSRF doğrulaması başarısız.');
    redirect(base_path("/{$slug}/trash"));
  }

  $kind = (string)($_POST['kind'] ?? '');
  $id = (int)($_POST['id'] ?? 0);

  if ($id <= 0) redirect(base_path("/{$slug}/trash"));

  if ($kind === 'customer') {
    $st = $pdo->prepare("UPDATE customers SET deleted_at=NULL WHERE id=? AND company_id=?");
    $st->execute([$id,$cid]);
    flash_set('ok', 'Müşteri geri alındı.');
  } elseif ($kind === 'product') {
    $st = $pdo->prepare("UPDATE products SET deleted_at=NULL WHERE id=? AND company_id=?");
    $st->execute([$id,$cid]);
    flash_set('ok', 'Ürün geri alındı.');
  }

  redirect(base_path("/{$slug}/trash"));
}

function panel_trash_delete_post(): void {
  $pdo = $GLOBALS['pdo'];
  $cid = (int)$GLOBALS['tenant']['id'];
  $slug = (string)$GLOBALS['tenant']['slug'];

  $csrf = (string)($_POST['csrf'] ?? '');
  if (!csrf_verify($csrf)) {
    flash_set('err', 'CSRF doğrulaması başarısız.');
    redirect(base_path("/{$slug}/trash"));
  }

  $kind = (string)($_POST['kind'] ?? '');
  $id = (int)($_POST['id'] ?? 0);
  if ($id <= 0) redirect(base_path("/{$slug}/trash"));

  if ($kind === 'customer') {
    $st = $pdo->prepare("DELETE FROM customers WHERE id=? AND company_id=?");
    $st->execute([$id,$cid]);
    flash_set('ok', 'Müşteri kalıcı silindi.');
  } elseif ($kind === 'product') {
    $st = $pdo->prepare("DELETE FROM products WHERE id=? AND company_id=?");
    $st->execute([$id,$cid]);
    flash_set('ok', 'Ürün kalıcı silindi.');
  }

  redirect(base_path("/{$slug}/trash"));
}
function panel_create(): void { panel_render('create'); }
